<?php

function getFaviconPath() {
    global $pdo;
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM store_settings WHERE setting_key = 'store_logo' AND setting_group = 'store_info' LIMIT 1");
        $stmt->execute();
        $logoPath = $stmt->fetchColumn();
        
        if ($logoPath && file_exists($logoPath)) {
            return $logoPath;
        }
        
        // Default favicon if no logo exists
        return 'assets/images/default-favicon.png';
    } catch (PDOException $e) {
        error_log("Error getting favicon path: " . $e->getMessage());
        return 'assets/images/default-favicon.png';
    }
} 